/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RequestFlowMainTableRow {
    private final int number;
    private final long releaseDate;
    private final long startDate;
    private final long endDate;
    private final long dueDate;
    private final GeneralizedOrderRequest gor;
    private final GeneralizedActionRequest gar;
    private final GeneralizedActionRequest prevGar;
    private final List<String> ingredients;
    private final List<String> workplaces;

    public RequestFlowMainTableRow(int number, GeneralizedOrderRequest gor, GeneralizedActionRequest gar, GeneralizedActionRequest prevGar) {
        this.number = number;
        this.releaseDate = gor.getReleaseDate();
        this.startDate = gor.getStartDate();
        this.endDate = gor.getEndDate();
        this.dueDate = gor.getDueDate();
        this.gor = gor;
        this.gar = gar;
        this.prevGar = prevGar;
        this.ingredients = new ArrayList<String>();
        this.workplaces = new ArrayList<String>();
        for (MaterialQuantity ingredient : gar.getAction().getBom().ingredients()) {
            this.ingredients.add(ingredient.getMaterial().getName());
        }
        for (ActionActivity aa : gar.getActivities()) {
            if (this.workplaces.contains(aa.getWorkplace().getName())) continue;
            this.workplaces.add(aa.getWorkplace().getName());
        }
        Collections.sort(this.ingredients);
        Collections.sort(this.workplaces);
    }

    public RequestFlowMainTableRow(int number, GeneralizedOrderRequest gor, long release, long start, long end, long due, GeneralizedActionRequest gar, GeneralizedActionRequest prevGar) {
        this.number = number;
        this.releaseDate = release;
        this.startDate = start;
        this.endDate = end;
        this.dueDate = due;
        this.gor = gor;
        this.gar = gar;
        this.prevGar = prevGar;
        this.ingredients = new ArrayList<String>();
        this.workplaces = new ArrayList<String>();
        for (MaterialQuantity ingredient : gar.getAction().getBom().ingredients()) {
            this.ingredients.add(ingredient.getMaterial().getName());
        }
        for (ActionActivity aa : gar.getActivities()) {
            if (this.workplaces.contains(aa.getWorkplace().getName())) continue;
            this.workplaces.add(aa.getWorkplace().getName());
        }
        Collections.sort(this.ingredients);
        Collections.sort(this.workplaces);
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isPlanned() {
        return !this.gar.getActivities().isEmpty();
    }

    public GeneralizedOrderRequest getGor() {
        return this.gor;
    }

    public Action getAction() {
        return this.gar.getAction();
    }

    public String getCapabilityInfo() {
        return String.format("%s (%s)", this.gar.getAction().getCapabilityReq(), StringUtils.join(this.workplaces, ", "));
    }

    public String getMaterialInfo() {
        return StringUtils.join(this.ingredients, ", ");
    }

    public long getStartTime() {
        return ReportUtilities.getStartTime(this.gar, this.prevGar);
    }

    public long getEndTime() {
        return ReportUtilities.getEndTime(this.gar);
    }

    public long getTotalTime() {
        return ReportUtilities.getTotalTime(this.gar, this.prevGar);
    }

    public long getProductionTime() {
        return ReportUtilities.getProductionTime(this.gar);
    }

    public long getLogisticTime() {
        return ReportUtilities.getLogisticTime(this.gar, this.prevGar);
    }

    public long getWaitingTime() {
        return ReportUtilities.getWaitingTime(this.gar, this.prevGar);
    }

    public double getRealRelative() {
        long nom = this.getTotalTime();
        long denom = ReportUtilities.getWindowSize(this.releaseDate, this.startDate, this.endDate);
        return ReportUtilities.getSafeRatio(nom, denom);
    }

    public double getWaitRelative() {
        long nom = this.getWaitingTime();
        long denom = ReportUtilities.getWindowSize(this.releaseDate, this.startDate, this.endDate);
        return ReportUtilities.getSafeRatio(nom, denom);
    }

    public double getReservedRelative() {
        long nom = this.getEndTime() - Math.min(this.releaseDate, this.startDate);
        long denom = ReportUtilities.getWindowSize(this.releaseDate, this.startDate, this.dueDate);
        return ReportUtilities.getSafeRatio(nom, denom);
    }
}

